document.addEventListener( 'DOMContentLoaded', function () {
	var spentTime = 0;
	var current_url = document.URL;
	var target_url = current_url + ((current_url.indexOf('?') > 0) ? '&' : '?');
	
	//track user spent time and hit (when user leaving the page)	
	window.onbeforeunload = function(){
		if(spentTime > 0){			
			var url = target_url + 'tracktime&spent_time=' + spentTime;
			var r = new XMLHttpRequest(); 
			r.open("GET", url, true);			
			r.send();
		}	
	}
	
	//update current spent time on page
	setInterval(function(){ spentTime = spentTime + 1; }, 1000);	
}, false );

/*
//jQuery version need to fix. Mediawiki did not see jQuery object
$(document).ready(function(){
	var spentTime = 0;
	var current_url = document.URL;
	var target_url = current_url + ((current_url.indexOf('?') > 0) ? '&' : '?');
	
	//track user spent time and hit (when user leaving the page)	
	$(window).on('beforeunload', function(){
		if(spentTime > 0){
			$.ajax({       
				type: "POST", 
				url: target_url + 'tracktime',       
				data: {
					'spent_time': spentTime
				}, 
				dataType: 'json'				
			});
		}		
    });	
	
	//update current spent time on page
	setInterval(function(){ spentTime = spentTime + 1; }, 1000);
});*/